clear all;

Xi = [1 0 0 1  1 -1 -1;
      0 1 0 1 -1  1 -1;
      0 0 1 1 -1 -1  1];
nu = [1;1;1;1;1;1;1];

Supp_max = [3 3 3];
Supp_min = [-2 -2 -2];

[X Y Z] = ndgrid(0:0.5:1,0:0.5:1,0:0.5:1);

p = [X(:) Y(:) Z(:)];

n = size(p,1);

iCubesFilled = 1;

m = 1;
ncubes = prod(Supp_max-Supp_min);

for x=Supp_min(1):(Supp_max(1)-1)
	for y=Supp_min(2):(Supp_max(2)-1)
		for z=Supp_min(3):(Supp_max(3)-1)
			offset = repmat([x y z],n,1);
			disp(sprintf('Computing samples in the cube [%d,%d,%d] (%d/%d)', [x y z], m, ncubes));
			v = box_eval(Xi,nu,(p+offset));
			v_max = max(v);
			[n_max d_max] = rat(v_max,1.e-10);

			if max(n_max) > 0
				disp('-----This cube is `filled''');
				icube = [x y z];
				CubesFilled(iCubesFilled,:) = [icube];
				iCubesFilled = iCubesFilled+1;			
			end
			m = m+1;
		end
	end
end

save 'd7_cubes_filled.mat' CubesFilled;
