clear all;

P = path;
path(P,'../common');
P = path;
path(P,'../box_eval');
P = path;
path(P,'../deboor');

format rat;	% change to "rational" format

% All the degree 4 barycentric combinations of 4 variables (integer elements).
global Bary;	

% Positions of four vertices of tetrahedra stored in a hash table.
global Tets;	

% List of all the valid indices for tetrahedra.
% Note that even there are though 2^6=64 possible indices to access the tetrahedra hash table, only 24 of them are valid ones.
global iTets;	
				
% Initializes the tetrahedron index.
itet = zeros(6);	

% Initializes degree 4 barycentric combination (35x4)
Bary = tri_bary(4);	

% Generates hash table and valid index list.
[Tets iTets] = d7_hash_tet;	

n = 1;	% Counter to show the progress.

load 'd7_cubes_filled.mat' CubesFilled;

Supp_min = [-2 -2 -2];
Supp_max = [3 3 3];

xmin = Supp_min(1);
xmax = Supp_max(1)-1;
ymin = Supp_min(2);
ymax = Supp_max(2)-1;
zmin = Supp_min(3);
zmax = Supp_max(3)-1;

clear BezCoeffRat;

global SP_bary;
global inv_M;
global Xi;

Xi = [1 0 0 1  1 -1 -1;
      0 1 0 1 -1  1 -1;
      0 0 1 1 -1 -1  1];

SP_bary = repmat([1 1 1 1]/8,35,1) + Bary/8;
M = multinomial(SP_bary,4);
inv_M = inv(M);
nCubesFilled = size(CubesFilled,1);
nTets = size(iTets,1);

for x = xmin:xmax
	for y = ymin:ymax
		for z = zmin:zmax
			% cube index
			icube = [x y z];

			for i=1:nTets
				itet = iTets(i);

				BezCoeffRat(d7_convert_index(icube,itet),:) = zeros(1,35);
			end
		end
	end
end
for j=1:nCubesFilled
	icube = CubesFilled(j,:);
	for i = 1:nTets		% For each tetrahedron...
		itet = iTets(i);	% tetrahedron index

		disp(sprintf('calculating Bezier coefficients for (icube = [%d %d %d] itet = %d) (%d/%d)', ...
			icube, itet, n, nCubesFilled*nTets));

		tic
		coeff = d7_compute_bez_coeff(icube,itet);	% Computes the coefficients.
		toc

		BezCoeffRat(d7_convert_index(icube,itet),:) = coeff(:)';

		n = n+1;
	end
end

save 'd7_bez_coeff_rat.mat' BezCoeffRat;


