function [X Y Z V] = d7_eval_grid_box_basis(xmin,xmax,ymin,ymax,zmin,zmax,xres,yres,zres)

	[X,Y,Z] = meshgrid((0:xres)*(xmax-xmin)/xres + xmin, (0:yres)*(ymax-ymin)/yres + ymin, (0:zres)*(zmax-zmin)/zres + zmin);

	p = [X(:) Y(:) Z(:)];

	Xi = [1 0 0 1  1 -1 -1;
	      0 1 0 1 -1  1 -1;
	      0 0 1 1 -1 -1  1];
	nu = [1;1;1;1;1;1;1];

	V = reshape(bxval(Xi,p'),yres+1,xres+1,zres+1);
%	V = reshape(box_eval(Xi,nu,p),yres+1,xres+1,zres+1);
end

