function [val] = d7_eval_bez_basis(p_cart)

	global BezCoeffInt;
	global BezCoeffRat;
	global Tets;
	global Bary;
	global invTets;
	global Denom;

	n = size(p_cart,1);

	X = p_cart(:,1);
	Y = p_cart(:,2);
	Z = p_cart(:,3);
	N = ones(n,1);

	supp = (X>-2*N) .* (X<3*N) .* (Y>-2*N) .* (Y<3*N) .* (Z>-2*N) .* (Z<3*N);

	isupp = find(supp);
	nsupp = size(isupp,1);

	val = zeros(n,1);

	p_supp = p_cart(isupp,:);

	[icube itet] = d7_find_tet(p_supp);

	invtets = invTets(itet+1,:);

	p_cube = p_supp - floor(p_supp);

	B = repmat([p_cube ones(nsupp,1)],1,4).*invtets;
	p_bary = [sum(B(:,1:4),2) sum(B(:,5:8),2) sum(B(:,9:12),2) sum(B(:,13:16),2)];

	scale = 1/Denom;

	coeff = BezCoeffInt(d7_convert_index(icube,itet),:);

	val(isupp) = scale*eval_trivariate_bez(coeff,p_bary,4);
end

