function [val] = d7_eval_bez(coeff_box,p_cart)

	global BezCoeffInt;
	global Tets;
	global Bary;
	global invTets;
	global TblOffset;
	global BezCoeff_per_tet_packed;
	global CubesFilled;
	global Supp_min;
	global Supp_max;
	global nSupp;
	global Denom;

	scale = 1/Denom;

	n = size(p_cart,1);	% # of input points to be evaluated

	ncoeff = size(Bary,1);	% # of Bezier coefficients (depends on its degree)

	val = zeros(n,1);	% initializes the output value

	[icube itet] = d7_find_tet(p_cart);

	ncubes = prod(nSupp);

	igrid = floor(p_cart);	% grid index for the input points
	
	coeff_bez_combined = zeros(n,ncoeff);	

	[w h d] = size(coeff_box);	

	coeff_box_flat = coeff_box(:);	% `unfolds' the 3D volumetric data to 1D array

	select_coeff_combine = 0;	% try to use other methods for combining (adjusting) Bezier coefficients

	nCubesFilled = size(CubesFilled,1);
	tic;
	for i = 1:nCubesFilled
		icube = repmat(CubesFilled(i,:),n,1);
		iweight = igrid - icube;

		x = iweight(:,1);
		y = iweight(:,2);
		z = iweight(:,3);

		weight = coeff_box_flat((z-1)*w*h + (y-1)*w + x);

		coeff_bez_combined = coeff_bez_combined + repmat(weight,1,ncoeff).*BezCoeffInt(d7_convert_index(icube,itet),:);
	end
	disp('Combining the box-spline coefficients complete.');
	toc;

	p_cube = p_cart - igrid;

	invtets = invTets(itet+1,:);
	B = repmat([p_cube ones(n,1)],1,4).*invtets;
	p_bary = [sum(B(:,1:4),2) sum(B(:,5:8),2) sum(B(:,9:12),2) sum(B(:,13:16),2)];

	tic;
	val = scale*eval_trivariate_bez(coeff_bez_combined,p_bary,4);
	disp('Evaluating quartic Bezier polynomials complete.');
	toc;
end
