function [Pout] = d7_convert_to_quasi(Pin)
	% converts input data into quasi-interpolation form of 7-directional box spline
	%
	% quasi-interpolant for 7-directional box spline
	% Qf = f(0)
	%    + 1/2 ((D1 + D2 + D3)f)(0)
	%    + 1/4 ((D1D2 + D2D3 + D3D1)f)(0)
	%    - 1/12((D1^2 + D2^2 + D2^3)f)(0)
	%    + 1/8 ((D1D2D3)f)(0)
	%    - 1/12((D1^3 + D2^3 + D3^3)f)(0)
	%    - 1/24((D1^2D2 + D1D2^2 + D2^2D3 + D2D3^2 + D3^2D1 + D3D1^2)f)(0)
	%

	P = Pin;

	P_D1 = approx_der(Pin,[1 0 0]);
	P_D2 = approx_der(Pin,[0 1 0]);
	P_D3 = approx_der(Pin,[0 0 1]);

	P_D1_D2 = approx_der(Pin,[1 1 0]);
	P_D2_D3 = approx_der(Pin,[0 1 1]);
	P_D3_D1 = approx_der(Pin,[1 0 1]);

	P_D1_2 = approx_der(Pin,[2 0 0]);
	P_D2_2 = approx_der(Pin,[0 2 0]);
	P_D3_2 = approx_der(Pin,[0 0 2]);

	P_D1_D2_D3 = approx_der(Pin,[1 1 1]);

	P_D1_3 = approx_der(Pin,[3 0 0]);
	P_D2_3 = approx_der(Pin,[0 3 0]);
	P_D3_3 = approx_der(Pin,[0 0 3]);

	P_D1_2_D2 = approx_der(Pin,[2 1 0]);
	P_D1_D2_2 = approx_der(Pin,[1 2 0]);
	P_D2_2_D3 = approx_der(Pin,[0 2 1]);
	P_D2_D3_2 = approx_der(Pin,[0 1 2]);
	P_D3_2_D1 = approx_der(Pin,[1 0 2]);
	P_D3_D1_2 = approx_der(Pin,[2 0 1]);

	szP = [size(P);
			size(P_D1);
			size(P_D2);
			size(P_D3);
			size(P_D1_D2);
			size(P_D2_D3);
			size(P_D3_D1);
			size(P_D1_2);
			size(P_D2_2);
			size(P_D3_2);
			size(P_D1_D2_D3);
			size(P_D1_3);
			size(P_D2_3);
			size(P_D3_3);
			size(P_D1_2_D2);
			size(P_D1_D2_2);
			size(P_D2_2_D3);
			size(P_D2_D3_2);
			size(P_D3_2_D1);
			size(P_D3_D1_2)];
	
	szP_min = min(szP,[],1);

	ix = 1:szP_min(1);
	iy = 1:szP_min(2);
	iz = 1:szP_min(3);

	% Qf = f(0)
	%    + 1/2 ((D1 + D2 + D3)f)(0)
	%    + 1/4 ((D1D2 + D2D3 + D3D1)f)(0)
	%    - 1/12((D1^2 + D2^2 + D2^3)f)(0)
	%    + 1/8 ((D1D2D3)f)(0)
	%    - 1/12((D1^3 + D2^3 + D3^3)f)(0)
	%    - 1/24((D1^2D2 + D1D2^2 + D2^2D3 + D2D3^2 + D3^2D1 + D3D1^2)f)(0)

	Pout =			P(ix,iy,iz)													...
		+	(1/2) * (P_D1(ix,iy,iz) + P_D2(ix,iy,iz) + P_D3(ix,iy,iz))			...
		+	(1/4) * (P_D1_D2(ix,iy,iz) + P_D2_D3(ix,iy,iz) + P_D3_D1(ix,iy,iz))	...
		-	(1/12)* (P_D1_2(ix,iy,iz) + P_D2_2(ix,iy,iz) + P_D3_2(ix,iy,iz))	...	
		+	(1/8) * (P_D1_D2_D3(ix,iy,iz))										...
		-	(1/12)* (P_D1_3(ix,iy,iz) + P_D2_3(ix,iy,iz) + P_D3_3(ix,iy,iz))	...
		-	(1/24)* (P_D1_2_D2(ix,iy,iz) + P_D1_D2_2(ix,iy,iz) + P_D2_2_D3(ix,iy,iz) + P_D2_D3_2(ix,iy,iz) + P_D3_2_D1(ix,iy,iz) + P_D3_D1_2(ix,iy,iz));
end


