function [igrid invtets coeff] = d7_convert_to_bez(Pin)
	% igrid   : translation offset of the tetrahedra
	% invtets : inverse matrix of the tetrahedra to be used to compute barycentric coordinates
	% coeff   : list of the Bezier coefficients combined
	global	Supp_min;
	global	Supp_max;
	global	nSupp;
	global	Bary;
	global	CubesFilled;
	global	iTets;
	global	invTets;
	global	BezCoeff;

	ncoeff = size(Bary,1);	% # of Bezier coefficients (=35)
	ntets = size(iTets,1);	% # of tetrahedra in one cube (=24)

	nPin = size(Pin);						% size of the input lattice
	nPout = size(Pin) - nSupp + [1 1 1];	% size of the output lattice
	n = prod(nPout);						% # of the points of the ouput lattice

	[X Y Z] = meshgrid((1:nPout(1))-Supp_min(1),	...
						(1:nPout(2))-Supp_min(2),	...
						(1:nPout(3))-Supp_min(3));

	igrid = reparray([X(:) Y(:) Z(:)], [ntets 1], [1 3]);
	igrid
	pause
	itet = repmat(iTets(:,1),n,1);
	invtets = invTets(itet+1,1);

	coeff_box_flat = Pin(:);

	coeff = zeros(n*ntets,ncoeff);

	nCubesFilled = size(CubesFilled,1);

	for i=1:nCubesFilled
		tic

		icube = repmat(nSupp-CubesFilled(i,1:3) - [1 1 1],n*ntets,1);

		iweight = igrid - icube - repmat(Supp_min,n*ntets,1);

		x = iweight(:,1);
		y = iweight(:,2);
		z = iweight(:,3);

		weight = coeff_box_flat((z-1)*nPin(1)*nPin(2) + (y-1)*nPin(1) + x);

		coeff = coeff +	repmat(weight,1,ncoeff).*BezCoeff(convert_index(icube,itet),:);
		disp(sprintf('iterating %d/%d cube to combine Bezier coefficients complete',i,nCubesFilled));
		toc
	end
end
