clear all;

load 'd7_bez_coeff_rat.mat' BezCoeffRat;
load 'd7_cubes_filled.mat' CubesFilled;
[Tets iTets] = d7_hash_tet;

format rat;

denom = 2^9*3;

nCubesFilled = size(CubesFilled,1);
nTets = size(iTets,1);

coeff = zeros(1,35);

Supp_min = [-2 -2 -2];
Supp_max = [3 3 3];

xmin = Supp_min(1);
xmax = Supp_max(1)-1;
ymin = Supp_min(2);
ymax = Supp_max(2)-1;
zmin = Supp_min(3);
zmax = Supp_max(3)-1;

for x=xmin:xmax
	for y=ymin:ymax
		for z=zmin:zmax
			icube = [x y z];
			for i=1:size(iTets,1)
				itet = iTets(i);
				BezCoeffInt(d7_convert_index(icube,itet),:) = zeros(1,35);
			end
		end
	end
end

coeff = zeros(1,35);

for i=1:nCubesFilled
	icube = CubesFilled(i,1:3);
	for j=1:nTets
		itet = iTets(j);
		coeff = BezCoeffRat(d7_convert_index(icube,itet),:);	
		BezCoeffInt(d7_convert_index(icube,itet),:) = coeff*denom;
	end
end

save 'd7_bez_coeff_int.mat' BezCoeffInt;

