
d7_setup;

format;

res = 10;

xmin = 0.5;
xmax = 3;
xres = res;

ymin = 0.5;
ymax = 3;
yres = res;

zmin = 0.5;
zmax = 3;
zres = res;

[x y z] = ndgrid(	(0:xres)*(xmax-xmin)/xres + xmin,	...
					(0:yres)*(ymax-ymin)/yres + ymin,	...
					(0:zres)*(zmax-zmin)/zres + zmin);
[nx ny nz] = size(x);

disp(sprintf('input data: [%g,%g]x[%g,%g]x[%g,%g] with resolution of %dx%dx%d',	...
			xmin,xmax,ymin,ymax,zmin,zmax,nx,ny,nz));

p = [x(:) y(:) z(:)];

% de Boor's code
disp('method 1: computing with de Boor''s code...');
tic
v1 = bxval(Xi,p')';
toc

% Kobbelt's code
disp('method 2: computing with Kobbelt''s code...');
nu = [1 1 1 1 1 1 1]';
tic
v2 = box_eval(Xi,nu,p);
toc

% Bezier form
disp('method 3: computing with Bezier form');
tic
v3 = d7_eval_bez_basis(p);
toc

diff12 = v1- v2;
disp(sprintf('error between method 1 and 2: %g ~ %g', min(diff12), max(diff12)));
diff23 = v2- v3;
disp(sprintf('error between method 2 and 3: %g ~ %g', min(diff23), max(diff23)));

diff13 = v1- v3;
disp(sprintf('error between method 1 and 3: %g ~ %g', min(diff13), max(diff13)));

