clear all;

P = path;
path(P,'../common');
P = path;
path(P,'../subset');
P = path;
path(P,'../deboor');
P = path;
path(P,'../box_eval');
P = path;
path(P,'../mri_toolbox_v1.5');
P = path;
path(P,'../reconstruction');

% First several global variables are to be initialized.

global Bary;		% degree 3 barycentric combinations
global Bary_inv;
global Tets;		% hash table for the tetrahedra in a cube
global iTets;		% index list of valid tetrahedra
global BezCoeffInt;	% quartic Bezier tetrahedra converted from trivariate 7-directional box spline
global det_Q;
global invTets;		% Inverse matrices to be used as barycentric coordinate function
global Xi;
global Supp_min;
global Supp_max;
global nSupp;
global Q;
global Qinv;
global nTets;
global CubesFilled;
global Denom;

Xi = [1 -1 1  1 0  0;
      1  1 0  0 1 -1;
      0  0 1 -1 1  1];
Supp_min = [-1 -1 -1];
Supp_max = [ 2  2  2];
nSupp = Supp_max - Supp_min;
nTets = 10;

[Bary Bary_inv] = tri_bary(3);
[Tets iTets] = d6_hash_tet;
load 'd6_bez_coeff_int.mat' BezCoeffInt;
load 'd6_invtets.mat' invTets;
load 'd6_cubes_filled.mat' CubesFilled;
%	
%	[ 1 -1 1  1 0  0]   [1 0 1][1  0 0  1 0 -1]
%	[ 1  1 0  0 1 -1] = [1 1 0][0  1 0 -1 1  0]
%	[ 0  0 1 -1 1  1]   [0 1 1][0 -1 1  0 0  1] 
%	-----------------   -------
%	       Xi            inv(Q)
%	
Q = [ 1  1 -1;
     -1  1  1;
      1 -1  1]/2;

Qinv = inv(Q);
det_Q = det(Q);

Denom = 24;

