function [Tets,iTets] = d6_hash_tet

	% - Generates hash table which contains four vertices of the tetrahedra.

	iTets(1,:) = bin2dec('00000');
	iTets(2,:) = bin2dec('11111');
	iTets(3,:) = bin2dec('10010');
	iTets(4,:) = bin2dec('10011');
	iTets(5,:) = bin2dec('10001');

	iTets(6,:) = bin2dec('10000');
	iTets(7,:) = bin2dec('10110');
	iTets(8,:) = bin2dec('10111');
	iTets(9,:) = bin2dec('10100');
	iTets(10,:)= bin2dec('10101');

	% Please refer to "find_tet.m" for the way of indexing tetrahedra.
	c = [1 1 1;1 1 1;1 1 1;1 1 1];

	Tets(bin2dec('00000')+1,:,:) = [-1 -1 -1 ; +1 -1 -1 ; -1 +1 -1 ; -1 -1 +1]+c;
	Tets(bin2dec('11111')+1,:,:) = [+1 +1 +1 ; +1 -1 +1 ; -1 +1 +1 ; +1 +1 -1]+c;
	Tets(bin2dec('10010')+1,:,:) = [ 0  0  0 ; +1 -1 +1 ; -1 -1 +1 ; +1 -1 -1]+c;
	Tets(bin2dec('10011')+1,:,:) = [ 0  0  0 ; -1 +1 +1 ; -1 -1 +1 ; +1 -1 +1]+c;
	Tets(bin2dec('10001')+1,:,:) = [ 0  0  0 ; -1 -1 +1 ; -1 +1 +1 ; -1 +1 -1]+c;

	Tets(bin2dec('10000')+1,:,:) = [ 0  0  0 ; -1 -1 +1 ; -1 +1 -1 ; +1 -1 -1]+c;
	Tets(bin2dec('10110')+1,:,:) = [ 0  0  0 ; +1 -1 +1 ; +1 -1 -1 ; +1 +1 -1]+c;
	Tets(bin2dec('10111')+1,:,:) = [ 0  0  0 ; -1 +1 +1 ; +1 -1 +1 ; +1 +1 -1]+c;
	Tets(bin2dec('10100')+1,:,:) = [ 0  0  0 ; -1 +1 -1 ; +1 +1 -1 ; +1 -1 -1]+c;
	Tets(bin2dec('10101')+1,:,:) = [ 0  0  0 ; -1 +1 +1 ; +1 +1 -1 ; -1 +1 -1]+c;

	Tets = Tets/2;
end
