clear all;

load 'd6_bez_coeff_rat.mat' BezCoeffRat;
load 'd6_cubes_filled.mat' CubesFilled;
[Tets iTets] = d6_hash_tet;

format rat;

nCubesFilled = size(CubesFilled,1);
nTets = size(iTets,1);

coeff = zeros(1,20);

lcm_den = 1;

for i=1:nCubesFilled
	icube = CubesFilled(i,:);
	for j=1:nTets
		itet = iTets(j);
		coeff(:) = BezCoeffRat(d6_convert_index(icube,itet),:);
		ipos = find(coeff);
		[n d] = rat(coeff(ipos),1.e-10);
		for k=1:size(d,2)
			lcm_den = lcm(lcm_den,d(k));
		end
	end
end

lcm_den
