function [dim]=d6_export_povray(fid,threshold,bez_scale,Pin)
	global	CubesFilled;
	global	BezCoeffInt;
	global	iTets;
	global	invTets;
	global	Tets;
	global	Supp_min;
	global	nSupp;
	global	color_for_all;
	global	Denom;
	global	det_Q;


	[dim igrid itet bez_coeff] = d6_convert_to_bez(Pin);

	scale = Denom;
%	scale = Denom/det_Q;

	supp_max = [max(igrid(:,1)) max(igrid(:,2)) max(igrid(:,3))] + [1 1 1];
	supp_min = [min(igrid(:,1)) min(igrid(:,2)) min(igrid(:,3))];

	n_in = size(igrid,1);

	for i=1:n_in
		bez_coeff_max = max(bez_coeff(i,:));
		bez_coeff_min = min(bez_coeff(i,:));
		if (bez_coeff_min > threshold*scale) || (bez_coeff_max < threshold*scale)
%		if (bez_coeff_max < threshold*scale)
%		if (bez_coeff_min > threshold*scale)
			continue;
		end
		invtet = invTets(itet(i)+1,:);

		str_invtet1 = sprintf('%g,%g,%g,%g,', invtet(1),invtet(2),invtet(3),invtet(4));
		str_invtet2 = sprintf('%g,%g,%g,%g,', invtet(5),invtet(6),invtet(7),invtet(8));
		str_invtet3 = sprintf('%g,%g,%g,%g,', invtet(9),invtet(10),invtet(11),invtet(12));
		str_invtet4 = sprintf('%g,%g,%g,%g', invtet(13),invtet(14),invtet(15),invtet(16));
		str_invtet = sprintf('\n\t\t\t\t\t%s\n\t\t\t\t\t%s\n\t\t\t\t\t%s\n\t\t\t\t\t%s',...
							str_invtet1,str_invtet2,str_invtet3,str_invtet4);
		str_coeff1 = sprintf('%g,%g,%g,%g,%g,', bez_coeff(i,1),bez_coeff(i,2),bez_coeff(i,3),bez_coeff(i,4),bez_coeff(i,5));
		str_coeff2 = sprintf('%g,%g,%g,%g,%g,', bez_coeff(i,6),bez_coeff(i,7),bez_coeff(i,8),bez_coeff(i,9),bez_coeff(i,10));
		str_coeff3 = sprintf('%g,%g,%g,%g,%g,', bez_coeff(i,11),bez_coeff(i,12),bez_coeff(i,13),bez_coeff(i,14),bez_coeff(i,15));
		str_coeff4 = sprintf('%g,%g,%g,%g,%g', bez_coeff(i,16),bez_coeff(i,17),bez_coeff(i,18),bez_coeff(i,19),bez_coeff(i,20));
		str_coeff = sprintf('\n\t\t\t\t\t%s\n\t\t\t\t\t%s\n\t\t\t\t\t%s\n\t\t\t\t\t%s',	...
				str_coeff1,str_coeff2,str_coeff3,str_coeff4);

		tet = zeros(4,3);
		tet(:,:) = Tets(itet(i)+1,:,:);

		n(1,:) = -cross(tet(2,:)-tet(1,:),tet(3,:)-tet(1,:));
		n(2,:) = -cross(tet(4,:)-tet(2,:),tet(3,:)-tet(2,:));
		n(3,:) = -cross(tet(4,:)-tet(1,:),tet(2,:)-tet(1,:));
		n(4,:) = -cross(tet(3,:)-tet(1,:),tet(4,:)-tet(1,:));

		n1 = n(1,:);
		n2 = n(2,:);
		n3 = n(3,:);
		n4 = n(4,:);

		len1 = sqrt(n1*n1');
		nn1 = n1./len1;
		d1 = n1*tet(1,:)';
		nd1 = d1/len1;

		len2 = sqrt(n2*n2');
		nn2 = n2./len2;
		d2 = n2*tet(2,:)';
		nd2 = d2/len2;

		len3 = sqrt(n3*n3');
		nn3 = n3./len3;
		d3 = n3*tet(1,:)';
		nd3 = d3/len3;

		len4 = sqrt(n4*n4');
		nn4 = n4./len4;
		d4 = n4*tet(1,:)';
		nd4 = d4/len4;

		str_pln1 = sprintf('(%g)*x+(%g)*y+(%g)*z-(%g)+THRESHOLD-PLANE_OFFSET', n1, d1);
		str_pln2 = sprintf('(%g)*x+(%g)*y+(%g)*z-(%g)+THRESHOLD-PLANE_OFFSET', n2, d2);
		str_pln3 = sprintf('(%g)*x+(%g)*y+(%g)*z-(%g)+THRESHOLD-PLANE_OFFSET', n3, d3);
		str_pln4 = sprintf('(%g)*x+(%g)*y+(%g)*z-(%g)+THRESHOLD-PLANE_OFFSET', n4, d4);

		str_bez = sprintf('-f_bez_tri_3(x,y,z,%s,%s)\n', str_invtet, str_coeff);
%		str_bez = '-1';

		fprintf(fid,'\t\tisosurface{\n');
		fprintf(fid,'\t\t\tfunction{\n');
		fprintf(fid,'\t\t\t\tmax(%s/%f,max(%s,max(%s,max(%s,%s))))',str_bez,scale,str_pln1,str_pln2,str_pln3,str_pln4);
		fprintf(fid,'\n\t\t\t}\n');
		fprintf(fid,'\t\t\tthreshold THRESHOLD\n');
		fprintf(fid,'\t\t\tmax_gradient MAX_GRADIENT\n');
%		fprintf(fid,'\t\t\topen\n');
		fprintf(fid,'\t\t\taccuracy ACCURACY\n');
		fprintf(fid,'\t\t\tcontained_by {box {<0-PLANE_OFFSET,0-PLANE_OFFSET,0-PLANE_OFFSET>,\n');
		fprintf(fid,'\t\t\t\t<1+PLANE_OFFSET,1+PLANE_OFFSET,1+PLANE_OFFSET>}}\n');

		fprintf(fid, '\t\t\ttranslate <%g,%g,%g>\n', igrid(i,:)-(supp_max - supp_min)/2);

		if ~color_for_all
			fprintf(fid,'\t\t\ttexture {\n');
			fprintf(fid,'\t\t\t\tpigment{color <%g,%g,%g>}\n',rand,rand,rand);
			fprintf(fid,'\t\t\t\tfinish{IsoFinish}\n\t\t\t}\n');
		end

		fprintf(fid,'\t\t}\n');
	end

end

