clear all;

[Tets, iTets] = d6_hash_tet;

tet = zeros(4,3);

for i = 1:size(iTets,1)	% For each tetrahedron

	% Fetches the four vertex positions.
	tet(:,:) = Tets(iTets(i)+1,:,:);

	% Computes the inverse matrix. (which is the barycentric coordinate function)
	invtet = inv([tet ones(4,1)]);

	% Stores in the table in a flatten format.
	invTets(iTets(i)+1,:) = [invtet(1:4,1)' invtet(1:4,2)' invtet(1:4,3)' invtet(1:4,4)'];
end

save 'd6_invtets.mat' invTets;
