clear all;

Xi = [1 -1 1  1 0  0;
      1  1 0  0 1 -1;
      0  0 1 -1 1  1];
nu = [1;1;1;1;1;1];

Supp_max = [2 2 2];
Supp_min = [-1 -1 -1];

% Sampling grid of the unit cube, [0,1]^3.
% For more accuracy, we can make it finer.
[X Y Z] = ndgrid(0:0.1:1,0:0.1:1,0:0.1:1);

p = [X(:) Y(:) Z(:)];

n = size(p,1);

iCubesFilled = 1;

for x=Supp_min(1):(Supp_max(1)-1)
	for y=Supp_min(2):(Supp_max(2)-1)
		for z=Supp_min(3):(Supp_max(3)-1)
			offset = repmat([x y z],n,1);
			v = box_eval(Xi,nu,(p+offset));
			v_max = max(v);
			[n_max d_max] = rat(v_max,1.e-10);

			% If any value is non-zero, we consider this cube `filled'.
			if max(n_max) > 0
				icube = [x y z];
				CubesFilled(iCubesFilled,:) = [icube];
				iCubesFilled = iCubesFilled + 1;
			end
		end
	end
end

save 'd6_cubes_filled.mat' CubesFilled;

