clear all;


P = path;
path(P,'../common');
P = path;
path(P,'../deboor');
P = path;
path(P,'../box_eval');

format rat;

% All the degree 3 barycentric combinations of 4 variables (integer elements).
global Bary;	

% Positions of four vertices of tetrahedra stored in a hash table.
global Tets;	

% List of all the valid indices for tetrahedra.
% Note that even there are though 2^4=16 possible indices to access the tetrahedra hash table, only 6 of them are valid ones.
global iTets;	
				
% Initializes the tetrahedron index.
itet = zeros(4);	

% Initializes degree 3 barycentric combination (20x4)
Bary = tri_bary(3);	

% Generates hash table and valid index list.
[Tets iTets] = d6_hash_tet;	

n = 1;	% Counter to show the progress.

load 'd6_cubes_filled.mat' CubesFilled;

Supp_min = [-1 -1 -1];
Supp_max = [2 2 2];

xmin = Supp_min(1);
xmax = Supp_max(1)-1;
ymin = Supp_min(2);
ymax = Supp_max(2)-1;
zmin = Supp_min(3);
zmax = Supp_max(3)-1;

clear BezCoeffRat;

global SP_bary;
global inv_M;
global Xi;
global Q;

Xi = [1 -1 1  1 0  0;
      1  1 0  0 1 -1;
      0  0 1 -1 1  1];
Q = [ 1  1 -1;
     -1  1  1;
      1 -1  1]/2;

SP_bary = repmat([1 1 1 1]/7,20,1) + Bary/7;
M = multinomial(SP_bary,3);
inv_M = inv(M);
nCubesFilled = size(CubesFilled,1);
nTets = size(iTets,1);

for x = xmin:xmax
	for y = ymin:ymax
		for z = zmin:zmax
			% cube index
			icube = [x y z];	

			for i = 1:nTets	% For each tetrahedron...
				% tetrahedron index
				itet = iTets(i);	

				BezCoeffRat(d6_convert_index(icube,itet),:) = zeros(1,20);
			end
		end
	end
end
for j=1:nCubesFilled
	% cube index
	icube = CubesFilled(j,:);
	for i = 1:nTets	% For each tetrahedron...
		% tetrahedron index
		itet = iTets(i);	

		disp(sprintf('calculating Bezier coefficients for (icube = [%d %d %d] itet = %s) (%d/%d)', ...
			icube, dec2bin(itet), n, nCubesFilled*nTets));

		tic
		coeff = d6_compute_bez_coeff(icube,itet);	% Computes the coefficients.
		toc

		BezCoeffRat(d6_convert_index(icube,itet),:) = coeff(:)';

		n = n+1;
	end
end

save 'd6_bez_coeff_rat.mat' BezCoeffRat;

