function [X Y Z V] = d6_eval_grid_bez_basis(xmin, xmax, ymin, ymax, zmin, zmax, xres, yres, zres)

	[X Y Z] = meshgrid((0:xres)*(xmax-xmin)/xres + xmin, (0:yres)*(ymax-ymin)/yres + ymin, (0:zres)*(zmax-zmin)/zres + zmin);
%	[X Y Z] = ndgrid((0:xres)*(xmax-xmin)/xres + xmin, (0:yres)*(ymax-ymin)/yres + ymin, (0:zres)*(zmax-zmin)/zres + zmin);

	p = [X(:) Y(:) Z(:)];

	V_flat = d6_eval_bez_basis(p);

	V = reshape(V_flat,yres+1,xres+1,zres+1);
%	V = reshape(V_flat,xres+1,yres+1,zres+1);
end
