function [X Y Z V] = d6_eval_grid_bez(coeff_box, xmin, xmax, ymin, ymax, zmin, zmax, xres, yres, zres)
%
% coeff_box     : input data to be reconstructed. (coefficients of the box spline)
% xmin,xmax     : x range to be reconstructed. (array indices)
% ymin,ymax     : y range to be reconstructed. (array indices)
% zmin,zmax     : z range to be reconstructed. (array indices)
% xres,yres,zres: how many cubes in a unit cube?

	[X Y Z] = ndgrid((0:xres)*(xmax-xmin)/xres + xmin, (0:yres)*(ymax-ymin)/yres + ymin, (0:zres)*(zmax-zmin)/zres + zmin);
%	[X Y Z] = meshgrid((0:xres)*(xmax-xmin)/xres + xmin, (0:yres)*(ymax-ymin)/yres + ymin, (0:zres)*(zmax-zmin)/zres + zmin);
	
	p = [X(:) Y(:) Z(:)];

%	V = reshape(d6_eval_bez(coeff_box,p),xres+1,yres+1,zres+1);
	V = reshape(d6_eval_bez(coeff_box,p),yres+1,xres+1,zres+1);
end
