function [X Y Z V] = d6_eval_export_box_basis_sampled(res)
	tic

	% Assumes 'setup' is already called.

	% Evaluates 3D grid using Bezier tetrahedra.

	xmin = -1;
	xmax = 3;
	xres = (xmax-xmin)*res;

	ymin = -1;
	ymax = 3;
	yres = (ymax-ymin)*res;

	zmin = -1;
	zmax = 3;
	zres = (zmax-zmin)*res;

	[X Y Z V] = d6_eval_grid_bez(xmin,xmax,ymin,ymax,zmin,zmax,xres,yres,zres);

	toc

	filename = sprintf('box6d_%d.mat', res);

	save(filename,'X','Y','Z','V');
end
