% eval_bez3d_basis.m
%
% - Evaluates the Bezier tetrahedra at given point.
% - Input point is a 3D point in Cartesian coordinate system.
% - Three global variables (BezCoeff, Tets, Bary) are assumed to be initialized already.
%
function [val] = eval_bez3d_basis(p_cart)

	global BezCoeffInt;
	global Tets;
	global Bary;
	global det_Q;
	global invTets;
	global Denom;
	global Q;

	%{
	
	[ 1 -1 1  1 0  0]   [1 0 1][1  0 0  1 0 -1]
	[ 1  1 0  0 1 -1] = [1 1 0][0  1 0 -1 1  0]
	[ 0  0 1 -1 1  1]   [0 1 1][0 -1 1  0 0  1] 
	                    -------
                         inv(Q)
	
	        [ 1  1 -1]
	Q = 0.5*[-1  1  1]
	        [ 1 -1  1]
	%}
%	Q_inv = 0.5*[ 1  1 -1;
%			 -1  1  1;
%			  1 -1  1];

	p_cart = p_cart*(Q');
%	x_cart = x_cart*(Q_inv');

	n = size(p_cart,1);	% # of input points to be evaluated

	X = p_cart(:,1);
	Y = p_cart(:,2);
	Z = p_cart(:,3);
	N = ones(n,1);	% dummy array for vectorized calculation

	% only those within the support (approximated with an enclosing box) of the basis get value 1
	supp = (X>-1*N) .* (X<2*N) .* (Y>-1*N) .* (Y<2*N) .* (Z>-1*N) .* (Z<2*N);

	isupp = find(supp);	% indices of the input points within the (box-shaped) support
	nsupp = size(isupp,1);	% # of input points within the support

	val = zeros(n,1);	% initializes with 0

	p_supp = p_cart(isupp,:);	% input points within the support

	% Determines in which cube/tetrahedron pair the input point lies.
	[icube itet] = d6_find_tet(p_supp);

	invtets = invTets(itet+1,:);	% fetches inverse matrix to calculate barycentric coordinate

	% fetches Bezier coefficients
	% converts index pair into one number to access the hash table
	coeff = BezCoeffInt(d6_convert_index(icube,itet),:);	

%	x_local = x_supp - icube + repmat([1 1 1],nsupp,1);	% converts to local Cartesian coordinate
	p_cube = p_supp - floor(p_supp);

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%                                                                           %
	% NOTE                                                                      %
	%                                                                           %
	% To compute the barycentric coordinates, each input point needs to be      %
	% multiplied by the proper inverse matrix. But matrix-vector multiplication %
	% is hard to be vectorized. So we `unfold' the matrices and vectors.        %
	%                                                                           %
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	% intermediate calculation to compute barycentric coordinates
	% `unfolds' the inverse matrix for vectorized calculation
	B = repmat([p_cube ones(nsupp,1)],1,4).*invtets;

	p_bary = [sum(B(:,1:4),2) sum(B(:,5:8),2) sum(B(:,9:12),2) sum(B(:,13:16),2)];

	scale = det_Q/Denom;

	% intermediate calculation to compute output
%	M = multinomial(x_bary,3);
%	val(isupp) = scale*(sum(M.*coeff,2));

	val(isupp) = scale*eval_trivariate_bez(coeff,p_bary,3);
end
