function [val] = d6_eval_bez(coeff_box,p_cart)

	global BezCoeffInt;
	global Tets;
	global Bary;
	global det_Q;
	global invTets;
	global Q;
	global Supp_min;
	global Supp_max;
	global nSupp;
	global CubesFilled;
	global Denom;

	scale = 1/Denom;
%	scale = det_Q/Denom;

	n = size(p_cart,1);	% # of input points to be evaluated

	ncoeff = size(Bary,1);

	val = zeros(n,1);	% initializes output

	[icube itet] = d6_find_tet(p_cart);

	ncubes = prod(nSupp);

	igrid = floor(p_cart);

	coeff_bez_combined = zeros(n,ncoeff);

	[w h d] = size(coeff_box);


	coeff_box_flat = coeff_box(:);

	nCubesFilled = size(CubesFilled,1);
	for i = 1:nCubesFilled
		icube = repmat(CubesFilled(i,1:3),n,1);
		iweight = igrid - icube;

		x = iweight(:,1);
		y = iweight(:,2);
		z = iweight(:,3);

		weight = coeff_box_flat((z-1)*w*h + (y-1)*w + x);

		coeff_bez_combined = coeff_bez_combined + repmat(weight,1,size(Bary,1)).*BezCoeffInt(d6_convert_index(icube,itet),:);
	end

	p_cube = p_cart - igrid;

	invtets = invTets(itet+1,:);

	B = repmat([p_cube ones(n,1)],1,4).*invtets;

	p_bary = [sum(B(:,1:4),2),sum(B(:,5:8),2) sum(B(:,9:12),2) sum(B(:,13:16),2)];

	tic;
%	M = multinomial(p_bary,3);
%	val = sum(M.*coeff_bez_combined,2);
	val = scale*eval_trivariate_bez(coeff_bez_combined,p_bary,3);	
	disp('----Evaluation of Bezier polynomial complete.');
	toc
end
