clear;
clf;

d6_setup;

select_input = 3;

switch select_input
	case 1
		nx = 32;
		ny = 32;
		nz = 32;

		P_in = zeros(nx,ny,nz);

		P_in(floor(nx/2),floor(ny/2),floor(nz/2)) = 1;

		level = max(max(max(P_in)))/2;
	case 2
		avw = avw_img_read('../sample/Bucky');
		P_in = avw.img;
	case 3
		xmin = -0.7;
		xmax = 0.7;
		resx = 21;

		ymin = -0.7;
		ymax = 0.7;
		resy = 22;

		zmin = -0.7;
		zmax = 0.7;
		resz = 23;

		[Xin Yin Zin] = ndgrid(	xmin:((xmax-xmin)/resx):xmax,	...
								ymin:((ymax-ymin)/resy):ymax,	...
								zmin:((zmax-zmin)/resz):zmax);
%		sz_p = size(Xin);

		[nXin nYin nZin] = size(Xin);

		% We want to same on FCC lattice...
		% Qinv transforms Z^3 to FCC lattice
%		p = [x(:) y(:) z(:)];
		p = [Xin(:) Yin(:) Zin(:)]*(Qinv');	


%		p;
%		max_x = max(p(:,1))
%		max_y = max(p(:,2))
%		max_z = max(p(:,3))
%		min_x = min(p(:,1))
%		min_y = min(p(:,2))
%		min_z = min(p(:,3))
%		pause

		tic
		v = lobb(p,6,0.25);
		disp(sprintf('Lobb''s sample generated (%dx%dx%d) [%g:%g]x[%g:%g]x[%g:%g]',	...
					resx+1,resy+1,resz+1,xmin,xmax,ymin,ymax,zmin,zmax));
		toc

		P_in = reshape(v,nXin,nYin,nZin);

		level = 0.5;
end


tic
P_in_quasi = d6_convert_to_quasi(P_in);
disp('input data converted for quasi-interpolation');
disp(sprintf('size of P_in:%dx%dx%d',size(P_in,1),size(P_in,2),size(P_in,3)));
disp(sprintf('size of P_in_quasi:%dx%dx%d',size(P_in_quasi,1),size(P_in_quasi,2),size(P_in_quasi,3)));
toc

res = 4;
%span = size(P_in_quasi,1)-1;

xmin = 2;
%xmax = xmin+span;
xmax = size(P_in_quasi,1)-1;
xres = (xmax-xmin)*res;

ymin = 2;
%ymax = ymin+span+1;
ymax = size(P_in_quasi,2)-1;
yres = (ymax-ymin)*res;

zmin = 2;
%zmax = zmin+span+2;
zmax = size(P_in_quasi,3)-1;
zres = (zmax-zmin)*res;

[Xout Yout Zout V] = d6_eval_grid_bez(P_in_quasi,xmin,xmax,ymin,ymax,zmin,zmax,xres,yres,zres);

figure(1);
tic
%render_iso(P_in,level,Q);

iXin = 1:(nXin);
iYin = 1:(nYin);
iZin = 1:(nZin);

%render_iso2(P_in(iYin,iXin,iZin),Xin(iYin,iXin,iZin),Yin(iYin,iXin,iZin),Zin(iYin,iXin,iZin),level,Qinv);
render_iso2(P_in(iXin,iYin,iZin),Xin(iXin,iYin,iZin),Yin(iXin,iYin,iZin),Zin(iXin,iYin,iZin),level,Qinv);
%render_iso(P_in(xmin:xmax,ymin:ymax,zmin:zmax),level,eye(3));
%render_iso(P_in(xmin:xmax,ymin:ymax,zmin:zmax),level,Q);
hold on;
plot3(p(:,1),p(:,2),p(:,3),'.b');
disp(sprintf('computing isosurface for input data complete [%g:%g]x[%g:%g]x[%g:%g]',	...
			xmin,xmax,ymin,ymax,zmin,zmax));
toc;

%level = (min(min(min(V))) + max(max(max(V))))/2;
figure(2);
tic
%render_iso(V,level);
render_iso2(V,Xout,Yout,Zout,level,Qinv);
disp('computing isosurface for reconstructed data complete');
toc

