d6_setup;

global	color_for_all;

%threshold		=	5/384;
%threshold		=	0.001;
%scale			=	5;
%position		=	[-12 -10 0];
%rotation		=	[-20 0 0];
%
%threshold		=	0.01;
%scale			=	10;
%position		=	[-20 -20 30];
%rotation		=	[-20 0 0];

%scale			=	4.5/max(nSupp);
scale			=	4.5/max(nSupp);
position		=	[0 0 0];
%rotation		=	[45 30 0];
rotation		=	[47 33 0];

accuracy		=	0.00001;
%accuracy		=	0.001;
%stretch_normal	=	0.5;
plane_offset	=	0;
bez_scale		=	1;
threshold		=	0.1*bez_scale;
max_gradient	=	2*bez_scale;

color_for_all = false;

if color_for_all
	str_color = 'solid';
else
	str_color = 'color';
end
filename = sprintf('6dir_%g_%s.pov',threshold,str_color);
fid = fopen(filename,'wt');

fprintf(fid,	'#version 3.5;\n');
fprintf(fid,	'#include "colors.inc"\n');
fprintf(fid,	'#include "functions.inc"\n');
fprintf(fid,	'global_settings {\n');
fprintf(fid,	'assumed_gamma 1}\n');

%fprintf(fid,	'#declare	BGColor=<0.5,0.5,0.5>;\n');

fprintf(fid,	'#declare CamLoc = < 0, 0,-10>;\n');

fprintf(fid,	'camera {\n');
fprintf(fid,	'location CamLoc\n');
fprintf(fid,	'look_at < 0, 0, 0>\n');
fprintf(fid,	'angle 45}\n');

fprintf(fid,	'light_source {CamLoc color White*0.35}\n');
fprintf(fid,	'light_source {<-50, 150,-75> color White}\n');

%{
fprintf(fid,	'box {<-4,-3, 1>, < 4, 3, 2>\n');
fprintf(fid,	'texture {\n');
fprintf(fid,	'pigment {checker color rgb < 0.05, 0, 0.35>, color White}\n');
fprintf(fid,	'finish {ambient 0 diffuse 1}}}\n');
%}

fprintf(fid,	'#declare IsoFinish =\n');
fprintf(fid,	'finish {\n');
fprintf(fid,	'ambient 0 diffuse 1\n');
fprintf(fid,	'specular 1 roughness 0.02\n');
fprintf(fid,	'brilliance 2}\n');


%fprintf(fid, 'union{\n');
fprintf(fid, 'union{\n');
%	fprintf(fid, '#declare	MAX_GRADIENT=%g;', 10);
fprintf(fid, '#declare	THRESHOLD=%g;\n',-threshold);
fprintf(fid, '#declare	ACCURACY=%g;\n', accuracy);
fprintf(fid, '#declare	MAX_GRADIENT=%g;\n', max_gradient);
%fprintf(fid, '#declare	STRETCH_NORMAL=%g;\n', stretch_normal);
fprintf(fid, '#declare	PLANE_OFFSET=%g;\n', plane_offset);
fprintf(fid, '#declare	BEZ_SCALE=%g;\n', bez_scale);

fprintf(fid, '\tunion{\n');
d6_export_povray_bez_basis(fid,threshold,bez_scale);
fprintf(fid,sprintf('matrix <%g,%g,%g,%g,%g,%g,%g,%g,%g,%g,%g,%g>\n',	...
	Qinv(1,1), Qinv(1,2), Qinv(1,3),	...
	Qinv(2,1), Qinv(2,2), Qinv(2,3),	...
	Qinv(3,1), Qinv(3,2), Qinv(3,3),	...
	0, 0, 0));
fprintf(fid, '\t}\n');

fprintf(fid, '\tscale %g\n',scale);
fprintf(fid, '\trotate<%g,%g,%g>\n', rotation);
fprintf(fid, '\ttranslate<%g,%g,%g>\n', position);
if color_for_all
	fprintf(fid, '\ttexture {\n');
	fprintf(fid, '\tpigment {color <%g,%g,%g>}\n',[.8 .8 .8]);
	fprintf(fid, '\tfinish {IsoFinish}\n');
	fprintf(fid, '\t}\n');
end
fprintf(fid, '}\n');


