clear;

d6_setup;

select_input = 3;

switch select_input
	case 1
		nx = 32;
		ny = 32;
		nz = 32;

		P_in = zeros(nx,ny,nz);

		P_in(floor(nx/2),floor(ny/2),floor(nz/2)) = 1;

		level = max(max(max(P_in)))/2;
	case 2
		avw = avw_img_read('../sample/Bucky');
		P_in = avw.img;
	case 3
		range = 0.5;
		xmin = -range;
		xmax = range;
		resx = 25;

		ymin = -range;
		ymax = range;
		resy = 25;

		zmin = -range;
		zmax = range;
		resz = 25;

		[Xin Yin Zin] = ndgrid(	xmin:((xmax-xmin)/resx):xmax,	...
								ymin:((ymax-ymin)/resy):ymax,	...
								zmin:((zmax-zmin)/resz):zmax);

		[nXin nYin nZin] = size(Xin);

		p = [Xin(:) Yin(:) Zin(:)]*(Qinv');	

		tic
		v = lobb(p,6,0.25);
		disp(sprintf('-----Lobb''s sample generated (%dx%dx%d) [%g:%g]x[%g:%g]x[%g:%g]',	...
					resx+1,resy+1,resz+1,xmin,xmax,ymin,ymax,zmin,zmax));
		toc

		str_hdr = sprintf('// [%g,%g]x[%g,%g]x[%g,%g] with resolution of %gx%gx%g\n',	...
			xmin,xmax,ymin,ymax,zmin,zmax,resx,resy,resz);

		P_in = reshape(v,nXin,nYin,nZin);

		level = 0.5;
end

tic
P_in_quasi = d6_convert_to_quasi(P_in);
disp('-----Conversion to quasi-interpolant form complete.');
toc

global	color_for_all;

%scale			=	4.5/max(nSupp);
position		=	[0 -1 0];
%rotation		=	[45 30 0];
rotation		=	[-60 0 0];

%accuracy		=	1;
%accuracy		=	0.0001;
accuracy		=	0.000001;
plane_offset	=	0;
bez_scale		=	1;
threshold		=	0.5*bez_scale;
max_gradient	=	2*bez_scale;

color_for_all = true;

if color_for_all
	str_color = 'solid';
else
	str_color = 'color';
end
filename = sprintf('sample.pov');

tic
fid = fopen(filename,'wt');

fprintf(fid,	str_hdr);
fprintf(fid,	'#version 3.5;\n');
fprintf(fid,	'#include "colors.inc"\n');
fprintf(fid,	'#include "functions.inc"\n');
fprintf(fid,	'global_settings {\n');
fprintf(fid,	'assumed_gamma 1}\n');

%fprintf(fid,	'#declare	BGColor=<0.5,0.5,0.5>;\n');

fprintf(fid,	'#declare CamLoc = < 0, 0,-10>;\n');

fprintf(fid,	'camera {\n');
fprintf(fid,	'location CamLoc\n');
fprintf(fid,	'look_at < 0, 0, 0>\n');
fprintf(fid,	'angle 45}\n');

fprintf(fid,	'light_source {CamLoc color White*0.35}\n');
fprintf(fid,	'light_source {<-50, 150,-75> color White}\n');

%fprintf(fid,	'box {<-4,-3, 1>, < 4, 3, 2>\n');
%fprintf(fid,	'texture {\n');
%fprintf(fid,	'pigment {checker color rgb < 0.05, 0, 0.35>, color White}\n');
%fprintf(fid,	'finish {ambient 0 diffuse 1}}}\n');

fprintf(fid,	'#declare IsoFinish =\n');
fprintf(fid,	'finish {\n');
fprintf(fid,	'ambient 0 diffuse 1\n');
fprintf(fid,	'specular 1 roughness 0.02\n');
fprintf(fid,	'brilliance 2}\n');


%fprintf(fid, 'union{\n');
fprintf(fid, 'union{\n');
%	fprintf(fid, '#declare	MAX_GRADIENT=%g;', 10);
fprintf(fid, '#declare	THRESHOLD=%g;\n',-threshold);
fprintf(fid, '#declare	ACCURACY=%g;\n', accuracy);
fprintf(fid, '#declare	MAX_GRADIENT=%g;\n', max_gradient);
%fprintf(fid, '#declare	STRETCH_NORMAL=%g;\n', stretch_normal);
fprintf(fid, '#declare	PLANE_OFFSET=%g;\n', plane_offset);
fprintf(fid, '#declare	BEZ_SCALE=%g;\n', bez_scale);

fprintf(fid, '\tunion{\n');

[dim] = d6_export_povray(fid,threshold,bez_scale,P_in_quasi);

scale = 4.5/max(dim);
fprintf(fid,sprintf('matrix <%g,%g,%g,%g,%g,%g,%g,%g,%g,%g,%g,%g>\n',	...
	Qinv(1,1), Qinv(1,2), Qinv(1,3),	...
	Qinv(2,1), Qinv(2,2), Qinv(2,3),	...
	Qinv(3,1), Qinv(3,2), Qinv(3,3),	...
	0, 0, 0));
fprintf(fid, '\t}\n');

fprintf(fid, '\tscale %g\n',scale);
fprintf(fid, '\trotate<%g,%g,%g>\n', rotation);
fprintf(fid, '\ttranslate<%g,%g,%g>\n', position);
if color_for_all
	fprintf(fid, '\ttexture {\n');
	fprintf(fid, '\tpigment {color <%g,%g,%g>}\n',[.8 .8 .8]);
	fprintf(fid, '\tfinish {IsoFinish}\n');
	fprintf(fid, '\t}\n');
end
fprintf(fid, '}\n');
fclose(fid);
disp('-----Exporting in POV-Ray script format complete');
toc


