function [Pout] = d6_convert_to_quasi(Pin)
	% converts input data into quasi-interpolation form of 6-directional box spline
	%
	% quasi-interpolant for 7-directional box spline
	% Qf = f(0)
	%    + 1/2 ((D1 + D2 + D3)f)(0)
	%    + 1/3 ((D1D2 + D2D3 + D3D1)f)(0)
	%

	P = Pin;
	[nx ny nz] = size(Pin);

	P_D1 = (Pin(3:nx,2:(ny-1),2:(nz-1)) - Pin(1:(nx-2),2:(ny-1),2:(nz-1)))/2;
	P_D2 = (Pin(2:(nx-1),3:ny,2:(nz-1)) - Pin(2:(nx-1),1:(ny-2),2:(nz-1)))/2;
	P_D3 = (Pin(2:(nx-1),2:(ny-1),3:nz) - Pin(2:(nx-1),2:(ny-1),1:(nz-2)))/2;

	P_D1_D2 = (Pin(3:nx,3:ny,2:(nz-1)) - Pin(3:nx,1:(ny-2),2:(nz-1)) ...
			- Pin(1:(nx-2),3:ny,2:(nz-1)) + Pin(1:(nx-2),1:(ny-2),2:(nz-1)))/4;
	P_D2_D3 = (Pin(2:(nx-1),3:ny,3:nz) - Pin(2:(nx-1),3:ny,1:(nz-2)) ...
			- Pin(2:(nx-1),1:(ny-2),3:nz) + Pin(2:(nx-1),1:(ny-2),1:(nz-2)))/4;
	P_D3_D1 = (Pin(3:nx,2:(ny-1),3:nz) - Pin(1:(nx-2),2:(ny-1),3:nz) ...
			- Pin(3:nx,2:(ny-1),1:(nz-2)) + Pin(1:(nx-2),2:(ny-1),1:(nz-2)))/4;

	Pout = Pin(2:(nx-1),2:(ny-1),2:(nz-1)) + (1/2)*(P_D1+P_D2+P_D3) + (1/3)*(P_D1_D2+P_D2_D3+P_D3_D1);
end


