function [dim igrid itet coeff] = d6_convert_to_bez(Pin)
	global	nSupp;
	global	iTets;
	global	CubesFilled;
	global	Supp_min;
	global	Supp_max;
	global	Bary;
	global	BezCoeffInt;

	[nx_in ny_in nz_in] = size(Pin);

	[x y z] = ndgrid(	(1-Supp_min(1)):(nx_in-Supp_max(1)),	...
						(1-Supp_min(2)):(ny_in-Supp_max(2)),	...
						(1-Supp_min(3)):(nz_in-Supp_max(3)));

	dim = size(x);
	p = [x(:) y(:) z(:)];

	% # of cubes each of which contains Bezier tetrahedra.
	np = size(p,1);	

	% # of tetrahedra in a cube.
	ntets = size(iTets,1);	

	% total # of Bezier tetrahedra output
	n = np*ntets;	

	igrid = reparray(p,[ntets 1],[1 3]);

	itet = repmat(iTets,np,1);

	Pin_flat = Pin(:);

	% # of Bezier coefficients
	ncoeff = size(Bary,1);

	coeff = zeros(n,ncoeff);

	nCubesFilled = size(CubesFilled,1);

	for i=1:nCubesFilled
		icube = repmat(CubesFilled(i,1:3),n,1);
		iweight = igrid - icube;

		ix = iweight(:,1);
		iy = iweight(:,2);
		iz = iweight(:,3);

		weight = Pin_flat((iz-1)*nx_in*ny_in + (iy-1)*nx_in + ix);

		coeff = coeff + repmat(weight,1,ncoeff).*BezCoeffInt(d6_convert_index(icube,itet),:);
	end
end
