clear all;

load 'd6_bez_coeff_rat.mat' BezCoeffRat;
load 'd6_cubes_filled.mat' CubesFilled;
[Tets iTets] = d6_hash_tet;

format rat;

denom = 24;

nCubesFilled = size(CubesFilled,1);
nTets = size(iTets,1);

coeff = zeros(1,20);

Supp_min = [-1 -1 -1];
Supp_max = [2 2 2];

xmin = Supp_min(1);
xmax = Supp_max(1)-1;
ymin = Supp_min(2);
ymax = Supp_max(2)-1;
zmin = Supp_min(3);
zmax = Supp_max(3)-1;

for x = xmin:xmax
	for y = ymin:ymax
		for z = zmin:zmax
			icube = [x y z];	% cube index
			for i = 1:size(iTets,1)	% For each tetrahedron...
				itet = iTets(i);
				BezCoeffInt(d6_convert_index(icube,itet),:) = zeros(1,20);
			end
		end
	end
end

coeff = zeros(1,20);

for i=1:nCubesFilled
	icube = CubesFilled(i,1:3);
	for j=1:nTets
		itet = iTets(j);
		coeff = BezCoeffRat(d6_convert_index(icube,itet),:);	
		BezCoeffInt(d6_convert_index(icube,itet),:) = coeff*denom;
	end
end

save 'd6_bez_coeff_int.mat' BezCoeffInt;

