function coeff = d6_compute_bez_coeff(icube,itet)

	global Bary;
	global Tets;
	global SP_bary;
	global inv_M;
	global Xi;
	global Q;

	tet = zeros(4,3);

	% Fetches the four vertex positions from the hash table.
	% The vertex positions are all inside of the cube [0,1]^3.
	tet(:,:) = Tets(itet+1,:,:);

	% Translates the tetrahedron to its absolute position.
	tet = tet + repmat(icube,4,1);

	% Transforms the sampling positions to Cartesian coordinate
	% to pass to the box spline evaluation package.
	sp_cart = SP_bary*tet;

	nu = [1;1;1;1;1;1];	% Not required if de Boor's packages is used.

	% Evaluates the sampling points.
	sv = box_eval(Q*Xi,nu,sp_cart);
%	sv = bxval(Q*Xi,sp_cart')';

	% Computes the Bezier coefficients by solving the linear system.
	coeff = inv_M*sv;

	% Approximates to the nearest rational number to get exact rational coefficients.
	coeff = approx_rat(coeff);
end
