

function m = msmak(z,mask)
%
%        m = msmak(z, mask)
%
% returns in  m  the mesh-function contained in  mask  with center
%  z  (to be decoded by  msbrk.m ).  mask  is understood to
%  contain the nontrivial part of the two-dimensional mesh-function  
%               ZZ^2 --> RR: j |--> mask(j+z) . 
% E.g.,  msmak([1;1], 1)  provides the delta-mask. (See  convol.m  
% for more detail.)  Note that this requires one to look at the 
% matrix  mask  sideways. Also, since  mask  is a matrix, indexed
% in the standard way, i.e., with support equal to  [1:r]x[1:c] , 
% the center  z  must necessarily lie at, or to the south-west 
% (i.e., left and below) of the lower left corner of the smallest 
% rectangle containing the support of the mesh-function, with  mask
% smallest if  z is equal to that corner. E.g., the delta-function 
% is also provided by 
%                 msmak([3;2], [0 0 0 0; 0 0 0 0; 0 1 0 0])   
 

% C de Boor: 10 oct 90/ 25 jun 92
 

m = [z(:); size(mask)'; mask(:)];
 

 
