function values = bxval(xi,xx)
%
%        values = bxval(xi, xx)
%
% returns the values of the box spline with directions  xi  at the
% points  xx(:,j), j=1,2,...
 

% C de Boor: 23 jun 92
 

[dx,ignored] = size(xi); [d,ignored] = size(xx);
if (dx ~= d), 
  error('directions and points are of different dimensions.'), end
 

perturb = max(max(abs(xi)))*1.e-10;  % <<<  note use of tolerance
[values, undef] = bxrec(xi,xx);
while ~isempty(undef), %  perturb any point on the mesh, then retry
  [vu, uu] = ...
   bxrec(xi,xx(:,undef)+(rand(d,1)*perturb)*ones(1,length(undef)));
  values(undef) = vu;
  undef = undef(uu);
end
 

 

function [values,undef] = bxrec(xi,x)
%
%        [values, undef] = bxrec(xi, x)
%
% recursive m-file for computing (however expensively)  M\ttul{}\ttbl{}xi\ttbr(x). 
% Note that  x(:,undef)  have been found to lie `on' the mesh for  
% M\ttul{}\ttbl{}xi\ttbr, hence need to be perturbed by the calling program. For
% this reason, it is better to use  bxval  which calls on  bxrec  
% and perturbs the argument if need be until it gets it `off' 
% the mesh.
%    The action could be speeded up somewhat by recognizing 
% multiplicities explicitly.
 

%  C de Boor: 4 jul 92/ 12 aug 92
 

[s,n] = size(xi); [ignored,nx] = size(x); 
values = zeros(1,nx); undef = [];
  % zero values will be returned unless  xi  is of full rank.
 

% Compute the QR factorization for  xi  as a means of telling 
% whether or not  xi  is of full rank. Since the factorization is 
% needed for this, it also comes in handy for determining a 
% reasonable solution of  xi? = x .
[q,r,e] = qr(xi); ad = abs(diag(r)); 
                    % q is unitary, r is upper triangular,
                    % with absol.\ decreasing diagonal elements,
                    % and  e  is a permutation matrix.
if ad(1) < (1.e+10)*ad(s),% If  xi  is of full rank,   
 t = (r*e')\(q'*x);% compute t as the smallest solution of  xi?=x.
                         % Further,
 if (s==n),  % if xi is square, return the characteristic function
         % of  xi(\boxx) , divided by abs(det(xi)) , retaining in 
         %  undef  those  j  for which  x(:,j)  is on the mesh.
  undef = find(min([abs(t);abs(1-t)])<1.e-12); 
  ok = 1:nx; ok(undef)=[];
  values(ok) = (0<=min(t(:,ok))\&max(t(:,ok))<1)/prod(ad); 
 

 else,  % use the recurrence relations, but only for the  x(:,j)
    %  in the smallest axiparallel cube containing supp M\ttul\ttbl{}xi\ttbr, ... 
  g = find(max(x-sum(max(xi',zeros(n,s)))'*ones(1,nx))<=0\& ...
            min(x-sum(min(xi',zeros(n,s)))'*ones(1,nx))>=0);
  lg = length(g); 
  j=1; xicut = xi(:,2:n); %  xicut  contains all directions but the 
                        % one currently left out.
  while lg>0, % compute and add the jth term of the recurrence:
   [vj, uj] = bxrec(xicut,[x(:,g),x(:,g)-xi(:,j)*ones(1,lg)]);
   values(g) = ...
        values(g) + t(j,g).*vj(1:lg) + (1-t(j,g)).*vj(lg+[1:lg]);
   if ~isempty(uj), % remove undefineds from further consideration
      indic = zeros(1,lg); [1:lg,1:lg];
      indic(ans(uj)) = ones(1,length(uj)); uj = find(indic==1);
      undef = [undef, g(uj)]; g(uj) = []; lg = length(g);
   end
   if (j == n), break, end
   xicut(:,j) = xi(:,j);  % increment  j  and update  xicut .
   j = j+1;
  end
  values = values/(n-s);
 end
end
 

\

function m = convol(m1,m2)
%
%        m = convol(m1, m2)
%
%  returns the discrete convolution of the two masks contained in
%   m1 , m2  (as encoded by  msmak.m  and decoded by  msbrk.m ).
%  If one or the other of these functions is itself a convolution
%  product, it is more efficient to apply the sequence of factors.
 

%  C de Boor: 11 oct 90/ 25 jun 92
 

%  if  mi = maski(.+zi) , and  m = m1*m2 = sum\ttul{}j m1(.-j)m2(j) , 
%  with  *  here denoting convolution, then  
%     mask(.+z) = sum\ttul{}j mask1(.-j+z1)mask2(j+z2)
%  or
%     mask(.+z-z1-z2) = sum\ttul{}j mask1(.-j)mask2(j)
%  showing that the mask of the convolution product is built up by
%  adding, for each  j  in  supp2 := supp(mask2), the matrix  
%   mask1 mask2(j)  to the area  supp1+j +z-z1-z2  of  mask .
%  It is assumed below that, in fact, each  mask  is an ordinary
%  matrix,  i.e., indexed from 1 to ... .
%  While the center  z  is arbitrary, the required support of  mask
%  is minimized if we choose  z  as is done below.
 

%  Make the second mask the smaller one:
if (length(m1) < length(m2)), junk = m1; m1 = m2; m2 = junk; end
oo = [1;1];
[z1,rc1,mask1] = msbrk(m1); supp1 = [oo rc1];
[z2,rc2,mask2] = msbrk(m2); supp2 = [oo rc2];
% compute support and center of convolved mask:
supp = supp1+supp2-(z1+z2)*ones(1,2);
z = oo-supp(:,1); supp = supp + z*ones(1,2); rc = supp(:,2);
% compute convolved mask:
mask = zeros(rc(1),rc(2)); shsupp1 = supp1+(z-z1-z2)*ones(1,2);
rangex = shsupp1(1,1):shsupp1(1,2);
rangey = shsupp1(2,1):shsupp1(2,2);
for i=1:rc2(1);
for j=1:rc2(2);
   mask(rangex+i,rangey+j) = ...
                       mask(rangex+i,rangey+j) + mask1*mask2(i,j);
   end; end
m = msmak(z,mask);
 

 

function m  =  condir(m1,dir)
%
%        m  =  condir(m1, dir)
%
%  this specialization of  convol.m  returns the discrete convol-
%  ution of the mask contained in  m1  with the one-direction 
%  mask specified in  dir =  [x; y]*[0:(n-1)] .
 

%  C de Boor: 12 oct 90/ 25 jun 92
 

oo = [1; 1];
[z1,rc1,mask1] = msbrk(m1); supp1 = [oo rc1];
[jj,n] = size(dir); dor = dir+ones(jj,n); z2 = [1; 1];
if (dir(1,n)<0),
  z2(1) = 1-dir(1,n); dor(1,:) = dor(1,:)-dir(1,n)*ones(1,n); end
if (dir(2,n)<0),
  z2(2) = 1-dir(2,n); dor(2,:) = dor(2,:)-dir(2,n)*ones(1,n); end
supp2 = [oo abs(dir(:,n))+oo];
% compute support and center of convolved mask:
supp = supp1+supp2-(z1+z2)*ones(1,2);
z = oo-supp(:,1); supp= supp + z*ones(1,2); rc = supp(:,2);
% compute convolved mask:
mask= zeros(rc(1),rc(2)); shsupp1 = supp1+(z-z1-z2)*ones(1,2);
rangex = shsupp1(1,1):shsupp1(1,2);
rangey = shsupp1(2,1):shsupp1(2,2);
for i = 1:n;
   mask(rangex+dor(1,i),rangey+dor(2,i))= ...
                   mask(rangex+dor(1,i),rangey+dor(2,i)) + mask1;
   end
m = msmak(z,mask);
 

 

function mask = msxima(Xi,nh)
%
%        mask = msxima(Xi, nh)
%
% returns the (unscaled) mask associated with the directions  Xi  
% when subdividing each direction into  nh  pieces. The properly 
% scaled mask is obtained from this by division by  nh\ttha{}(n-2) .
 

% C de Boor: 12 oct 90
 

mask = msmak([1;1],[1]);
[s,n] = size(Xi);
if (s~=2), error('msxima now only works for bivariate Xi .'),end
 

for j=1:n
   mask = condir(mask,Xi(:,j)*[0:(nh-1)]);
   end
 

 

function m = msmak(z,mask)
%
%        m = msmak(z, mask)
%
% returns in  m  the mesh-function contained in  mask  with center
%  z  (to be decoded by  msbrk.m ).  mask  is understood to
%  contain the nontrivial part of the two-dimensional mesh-function  
%               ZZ\ttha{}2 --> RR: j |--> mask(j+z) . 
% E.g.,  msmak([1;1], 1)  provides the delta-mask. (See  convol.m  
% for more detail.)  Note that this requires one to look at the 
% matrix  mask  sideways. Also, since  mask  is a matrix, indexed
% in the standard way, i.e., with support equal to  [1:r]x[1:c] , 
% the center  z  must necessarily lie at, or to the south-west 
% (i.e., left and below) of the lower left corner of the smallest 
% rectangle containing the support of the mesh-function, with  mask
% smallest if  z is equal to that corner. E.g., the delta-function 
% is also provided by 
%                 msmak([3;2], [0 0 0 0; 0 0 0 0; 0 1 0 0])   
 

% C de Boor: 10 oct 90/ 25 jun 92
 

m = [z(:); size(mask)'; mask(:)];
 

 

function [z,rc,mask] = msbrk(m,print)
%
%        [z, rc, mask] = msbrk(m [,print])
%
%  returns the details of the mesh-function contained in  m , i.e.,
% of the map 
%               ZZ\ttha{}2 --> RR : j |--> mask(j+z) 
%  with  size(mask) =: rc . 
%    If a second argument is present, the details are printed out.
 

%  C de Boor: 10 oct 90
 

l = length(m); z = m(1:2); rc = m(3:4);
if (l-4 ~= rc(1)*rc(2)),
   error('The input does not seem to contain a mask.'), end
mask = reshape(m(5:l),rc(1),rc(2)); 
if (nargin > 1),  z, rc, mask, end
