% routine calling boxvall at the (tricky)  values
% corresponding to the centers of the defining cubes
% of xi

% 4 direction mesh
    xi = [ ...
	1 0 1  1;...
	0 1 1 -1];

% pts of the domain equally spaced
    [s,n] = size(xi);
    pts = [];	
    step = 1/2;		% spacing of evaluations
    mx = 1.5;		% width of cube HOPEFULLY enough
    rg = -mx:step:mx;
    sz = length(rg)	% number of samples in each dir
    for x = rg,	
	for y = rg,	
	    pts = [pts, [x,y]'];
	end
    end
    ctr = [3 1]'/2;  % box-spline ctr of support
    pts = ctr*ones(1,sz^s)+pts;    % points shifted wrto box ctr

    h = bxval(xi,pts);

    scl = 4^(1/step)
    vals = ones(sz,sz^(s-1));	% z varies per column; sz columns per x slice
    vals(:) = round(h*scl); 	% clean and scale
    [i,j,val] = find(vals);   	% pick nonzero elements only
    Y = (i-(sz+1)/2);		% times step would give coords
    X = (j-(sz+1)/2);
    [X Y val]'

