% DEVICES
%
% GUI for MATLAB-axis
%
% LEFT      : Elevation (viewing direction)
% BOTT      : Azimuth   
% RESET     : by clicking upper right panel 
%
% RIGHT     : Magnification
% RESET     : by clicking half-right panel
%
% UPPER LEFT : Shift in coordinaten directions
% RESET      : by clicking x,y,z

D_f = gcf;
D_az(D_f) = 37.5;
D_el(D_f) = 30.0;
D_mag(D_f) = 0;
D_dd = 0.030;
D_ds = 0.8;
D_dp = 0.25;
D_r = 1.33;

D_ax(D_f,:) = axis;
D_cax0(D_f,:) = [(D_ax(D_f,1)+D_ax(D_f,2))/2 (D_ax(D_f,1)+D_ax(D_f,2))/2 (D_ax(D_f,3)+D_ax(D_f,4))/2 (D_ax(D_f,3)+D_ax(D_f,4))/2 (D_ax(D_f,5)+D_ax(D_f,6))/2 (D_ax(D_f,5)+D_ax(D_f,6))/2];
D_dax(D_f,:) = axis - D_cax0(D_f,:);
D_cax(D_f,:) = D_cax0(D_f,:);
D_shx(D_f,:) = [.05 .05 0 0 0 0];
D_shy(D_f,:) = [0 0 .05 .05 0 0];
D_shz(D_f,:) = [0 0 0 0 .05 .05];

D_q(D_f,1) = uicontrol(...
'Units','normalized',...
'Style','Slider',...
'Min',-180,...
'Max',180,...
'Value',D_az(D_f),...
'CallBack', 'D_f = gcf; figure(D_f); D_az(D_f)=get(D_q(D_f,1),''Value''); set(D_q(D_f,3),''String'',[''az = '' int2str(D_az(D_f)) '' ,  el = '' int2str(D_el(D_f))]);view(-D_az(D_f),D_el(D_f));',...
'Position',[(1-D_ds)/2,0,D_ds,D_r*D_dd]);

D_q(D_f,2) = uicontrol(...
'Units','normalized',...
'Style','Slider',...
'Min',-90,...
'Max',90,...
'Value',D_el(D_f),...
'CallBack','D_f = gcf; figure(D_f); D_el(D_f)=get(D_q(D_f,2),''Value''); set(D_q(D_f,3),''String'',[''az = '' int2str(D_az(D_f)) '' ,  el = '' int2str(D_el(D_f))]);view(-D_az(D_f),D_el(D_f));',...
'Position',[0,(1-D_ds)/2,D_dd,D_ds]);

D_q(D_f,3) = uicontrol(...
'Units','normalized',...
'Style','Pushbutton',...
'Position',[1-D_dp,1-D_r*D_dd,D_dp,D_r*D_dd],...
'String',['az = ' int2str(D_az(D_f)) ' ,  el = ' int2str(D_el(D_f))],...
'CallBack','D_f = gcf; figure(D_f); D_el(D_f)=30;D_az(D_f)=37.5; set(D_q(D_f,3),''String'',[''az = '' int2str(D_az(D_f)) '' ,  el = '' int2str(D_el(D_f))]);set(D_q(D_f,1),''Value'',D_az(D_f)); set(D_q(D_f,2),''Value'',D_el(D_f)),view(-D_az(D_f),D_el(D_f));');

D_q(D_f,4) = uicontrol(...
'Units','normalized',...
'Style','Slider',...
'Min',-1,...
'Max',1,...
'Value',D_mag(D_f),...
'CallBack','D_f = gcf; figure(D_f); D_mag(D_f)=get(D_q(D_f,4),''Value'');set(D_q(D_f,5),''String'',[''mag='' num2str(D_mag(D_f),2)]); axis(D_cax(D_f,:)+10^(-D_mag(D_f))*D_dax(D_f,:));',...
'Position',[1-D_dd,(1-D_ds)/2,D_dd,D_ds]);

D_q(D_f,5) = uicontrol(...
'Units','normalized',...
'Style','Pushbutton',...
'Position',[1-2*D_dp,1-D_r*D_dd,D_dp,D_r*D_dd],...
'String',['mag = ' num2str(D_mag(D_f),2)],...
'CallBack','D_f = gcf; figure(D_f); D_mag(D_f)=0; set(D_q(D_f,5),''String'',[''mag='' num2str(D_mag(D_f),2)]); set(D_q(D_f,4),''Value'',D_mag(D_f)); axis(D_cax(D_f,:)+D_dax(D_f,:));');

uicontrol(...
'Units','normalized',...
'Style','Pushbutton',...
'Position',[0,1-D_r*D_dd,D_dd,D_r*D_dd],...
'String','-',...
'CallBack','D_f = gcf; figure(D_f); D_cax(D_f,:) = D_cax(D_f,:)+abs(D_dax(D_f,:)).*D_shx(D_f,:); axis(D_cax(D_f,:)+10^(-D_mag(D_f))*D_dax(D_f,:));');

uicontrol(...
'Units','normalized',...
'Style','Pushbutton',...
'Position',[D_dd,1-D_r*D_dd,D_dd,D_r*D_dd],...
'String','x',...
'CallBack','D_f = gcf; figure(D_f); D_cax(D_f,:) = D_cax0(D_f,:); axis(D_cax(D_f,:)+10^(-D_mag(D_f))*D_dax(D_f,:));');

uicontrol(...
'Units','normalized',...
'Style','Pushbutton',...
'Position',[2*D_dd,1-D_r*D_dd,D_dd,D_r*D_dd],...
'String','+',...
'CallBack','D_f = gcf; figure(D_f); D_cax(D_f,:) = D_cax(D_f,:)-abs(D_dax(D_f,:)).*D_shx(D_f,:); axis(D_cax(D_f,:)+10^(-D_mag(D_f))*D_dax(D_f,:));');


uicontrol(...
'Units','normalized',...
'Style','Pushbutton',...
'Position',[4*D_dd,1-D_r*D_dd,D_dd,D_r*D_dd],...
'String','-',...
'CallBack','D_f = gcf; figure(D_f); D_cax(D_f,:) = D_cax(D_f,:)+abs(D_dax(D_f,:)).*D_shy(D_f,:); axis(D_cax(D_f,:)+10^(-D_mag(D_f))*D_dax(D_f,:));');

uicontrol(...
'Units','normalized',...
'Style','Pushbutton',...
'Position',[5*D_dd,1-D_r*D_dd,D_dd,D_r*D_dd],...
'String','y',...
'CallBack','D_f = gcf; figure(D_f); D_cax(D_f,:) = D_cax0(D_f,:); axis(D_cax(D_f,:)+10^(-D_mag(D_f))*D_dax(D_f,:));');

uicontrol(...
'Units','normalized',...
'Style','Pushbutton',...
'Position',[6*D_dd,1-D_r*D_dd,D_dd,D_r*D_dd],...
'String','+',...
'CallBack','D_f = gcf; figure(D_f); D_cax(D_f,:) = D_cax(D_f,:)-abs(D_dax(D_f,:)).*D_shy(D_f,:); axis(D_cax(D_f,:)+10^(-D_mag(D_f))*D_dax(D_f,:));');


uicontrol(...
'Units','normalized',...
'Style','Pushbutton',...
'Position',[8*D_dd,1-D_r*D_dd,D_dd,D_r*D_dd],...
'String','-',...
'CallBack','D_f = gcf; figure(D_f); D_cax(D_f,:) = D_cax(D_f,:)+abs(D_dax(D_f,:)).*D_shz(D_f,:); axis(D_cax(D_f,:)+10^(-D_mag(D_f))*D_dax(D_f,:));');

uicontrol(...
'Units','normalized',...
'Style','Pushbutton',...
'Position',[9*D_dd,1-D_r*D_dd,D_dd,D_r*D_dd],...
'String','z',...
'CallBack','D_f = gcf; figure(D_f); D_cax(D_f,:) = D_cax0(D_f,:); axis(D_cax(D_f,:)+10^(-D_mag(D_f))*D_dax(D_f,:));');

uicontrol(...
'Units','normalized',...
'Style','Pushbutton',...
'Position',[10*D_dd,1-D_r*D_dd,D_dd,D_r*D_dd],...
'String','+',...
'CallBack','D_f = gcf; figure(D_f); D_cax(D_f,:) = D_cax(D_f,:)-abs(D_dax(D_f,:)).*D_shz(D_f,:); axis(D_cax(D_f,:)+10^(-D_mag(D_f))*D_dax(D_f,:));');

