% routine calling boxval at the (tricky)  values
% corresponding to the centers of the defining cubes
% of Xi

% 7 direction mesh
    Xi = [ ...
	1 0 0 1  1 -1 -1;...
	0 1 0 1 -1 -1  1;...
	0 0 1 1 -1  1 -1];

% generate pts of the domain equally spaced
    pts = [];	
    step = 1/4;		% spacing of evaluations
    %mx = 1.5;		% width of cube HOPEFULLY enough
    %mx = 2.0;		% width of cube HOPEFULLY enough
    mx = 2.5;		% width of cube is enough
    %mx = 3.0;		% equal to 
    rg = -mx:step:mx;
    sz = length(rg)	% number of samples in each dir
    for x = rg,	
	for y = rg,	
	    for z = rg,	
		pts = [pts, [x,y,z]'];
	    end
	end
    end
    ctr = sum(Xi')'/2;      %[1 1 1]'/2;  % box-spline ctr of support
    [s,n] = size(Xi);
    pts = ctr*ones(1,sz^s)+pts;    % points shifted wrto box ctr
    scl = 4^(1/step)
    vals = ones(sz,sz^(s-1));	% z varies per column; sz columns per x slice

    fid = fopen('5dirs.val','w');
    %fprintf(fid,'no shift\n');
    for c1=4:6,
	for c2=(c1+1):7,
	    [c1 c2]
	    xi = Xi(:,[1:3 c1 c2])  % box spline is defined by xi
	    h = bxval(xi,pts);

	    vals(:) = round(h*scl); 	% clean and scale
	    [i,j,val] = find(vals);   	% pick nonzero elements only
	    Z = (i-(sz+1)/2);		% * step
	    j1 = floor(j/sz);
	    j2 = rem(j,sz);
	    Y = (j2-(sz+1)/2);
	    X = (j1-(sz+1)/2);
	    XYZval = [X Y Z val]';

	    fprintf(fid,'\nXi: \n');
	    fprintf(fid,'%2d %2d %2d %2d %2d\n',xi');
	    fprintf(fid,'\nscale: %d\n',scl);
	    fprintf(fid,'\nx y z (index) multiple:\n');
	    fprintf(fid,'%3d %3d %3d %3d\n',XYZval);
	end;
    end;
    fclose(fid);
