
function m = convol(m1,m2)
%
%        m = convol(m1, m2)
%
%  returns the discrete convolution of the two masks contained in
%   m1 , m2  (as encoded by  msmak.m  and decoded by  msbrk.m ).
%  If one or the other of these functions is itself a convolution
%  product, it is more efficient to apply the sequence of factors.
 

%  C de Boor: 11 oct 90/ 25 jun 92
 

%  if  mi = maski(.+zi) , and  m = m1*m2 = sum_j m1(.-j)m2(j) , 
%  with  *  here denoting convolution, then  
%     mask(.+z) = sum_j mask1(.-j+z1)mask2(j+z2)
%  or
%     mask(.+z-z1-z2) = sum_j mask1(.-j)mask2(j)
%  showing that the mask of the convolution product is built up by
%  adding, for each  j  in  supp2 := supp(mask2), the matrix  
%   mask1 mask2(j)  to the area  supp1+j +z-z1-z2  of  mask .
%  It is assumed below that, in fact, each  mask  is an ordinary
%  matrix,  i.e., indexed from 1 to ... .
%  While the center  z  is arbitrary, the required support of  mask
%  is minimized if we choose  z  as is done below.
 

%  Make the second mask the smaller one:
if (length(m1) < length(m2)), junk = m1; m1 = m2; m2 = junk; end
oo = [1;1];
[z1,rc1,mask1] = msbrk(m1); supp1 = [oo rc1];
[z2,rc2,mask2] = msbrk(m2); supp2 = [oo rc2];
% compute support and center of convolved mask:
supp = supp1+supp2-(z1+z2)*ones(1,2);
z = oo-supp(:,1); supp = supp + z*ones(1,2); rc = supp(:,2);
% compute convolved mask:
mask = zeros(rc(1),rc(2)); shsupp1 = supp1+(z-z1-z2)*ones(1,2);
rangex = shsupp1(1,1):shsupp1(1,2);
rangey = shsupp1(2,1):shsupp1(2,2);
for i=1:rc2(1);
for j=1:rc2(2);
   mask(rangex+i,rangey+j) = ...
                       mask(rangex+i,rangey+j) + mask1*mask2(i,j);
   end; end
m = msmak(z,mask);
 

